/****** Object:  StoredProcedure [dbo].[P_DW_PRODUTOS_FALTA_GRUPO_PRODUTOS_FILIAL]    Script Date: 06/28/2012 17:11:11 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_DW_PRODUTOS_FALTA_GRUPO_PRODUTOS_FILIAL]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_DW_PRODUTOS_FALTA_GRUPO_PRODUTOS_FILIAL]
GO
GO
--EXECUTE P_DW_PRODUTOS_FALTA_GRUPO_PRODUTOS_FILIAL 1,'2016-11-30'
CREATE PROCEDURE [dbo].[P_DW_PRODUTOS_FALTA_GRUPO_PRODUTOS_FILIAL] (@CD_EMP INT = 1, @DT_INI DATETIME = NULL) AS
IF @DT_INI IS NULL
	BEGIN
		SET @DT_INI=DBO.F_ONTEM(); 
	END
DELETE FROM EST_PROD_CPL_ANALISE_FALTAS_FILIAL WHERE DT_MOV = @DT_INI

INSERT INTO EST_PROD_CPL_ANALISE_FALTAS_FILIAL

	(
		DT_MOV,
		CD_FILIAL,
		CD_EMP,
		CD_PROD,
		DS_PROD,
		NM_FABRIC,
		DS_SIGLA,
		DS_ARV_MERC_LINHA,
		TIPO_COMPRA,
		VLR_MEDIO_VD,
		QT_VD_DIA,
		PART_QTDE,
		PART_VLR,
		VLR_PERDA_VD,	
		QTDE_PERDA_VD,	
		MEDIAF, 
		EST_MTZ, 
		EST_PEND_MTZ,
		EST_PEND_LJ, 
		EMAX, 
		EXCESSO, 
		NECESSIDADE
	)

SELECT

	VD_PROD.DT_VD,   	
	VD_PROD.CD_FILIAL,
	CD_EMP = @CD_EMP,
	VD_PROD.CD_PROD,   	
	DS_PROD = CPL.DS_PROD,
	NM_FABRIC = CPL.NM_FABRIC,
	DS_SIGLA = CPL.DS_SIGLA,
	DS_ARV_MERC_LINHA = CPL.DS_ARV_MERC_LINHA,
	TIPO_COMPRA = CPL.TIPO,
	VLR_MEDIO_VD = VD.VLR_MEDIO_VD,
	QT_VD_DIA = VD.QT_VD_DIA,
	PART_QTDE =	CASE WHEN  VD.PART_QTDE_VD > 0 THEN      
		ROUND((VD_PROD.PART_QTDE / VD.PART_QTDE_VD) * 100,8) 
	ELSE     
		0 
	END, 
	PART_VLR = CASE WHEN  VD.PART_VLR_VD > 0 THEN      
		ROUND((VD_PROD.PART_VLR / VD.PART_VLR_VD) * 100,8) 
	ELSE     
		0 
	END,
	VLR_PERDA_VD = CASE WHEN VD.PART_VLR_VD >  0 THEN
		(VD.VLR_MEDIO_VD * ROUND((VD_PROD.PART_VLR / VD.PART_VLR_VD) * 100,8)) / 100
	ELSE 0 END,
	QTDE_PERDA_VD = CASE WHEN VD.PART_QTDE_VD > 0 THEN
		 (VD.QT_VD_DIA * ROUND((VD_PROD.PART_QTDE / VD.PART_QTDE_VD) * 100,8))  / 100
	ELSE 0	END,

	MEDIAF = CPL.MEDIAF,
	EST_MTZ = CPL.EST_MTZ,
	EST_PEND_MTZ = CPL.QT_PEND_MTZ,
	EST_PEND_LJ = CPL.QT_PEND_LJ,
	EMAX = CPL.EMAX,
	EXCESSO = E.EXCESSO,
	NECESSIDADE = CPL.NECESSIDADE

FROM 
	(SELECT   
		a.CD_FILIAL,
		a.CD_PROD,   
		a.DT_VD,
		SUM(a.PART_QTDE) AS PART_QTDE,   
		SUM(a.PART_VLR) AS PART_VLR
	FROM 
		EST_PROD_CPL_ANALISE_DIARIO a
		INNER JOIN EST_PROD p ON 
		a.CD_EMP = p.CD_EMP AND 
		a.Cd_Prod = P.Cd_Prod 
		
	WHERE   
		a.CD_EMP = @CD_EMP
		AND a.DT_VD =  @DT_INI
		AND a.QT_EST <= 0 
		AND p.STS_PROD = 0
		AND p.FLAG_ANALISE_FALTAS=0
		AND a.CD_FILIAL NOT IN (SELECT CD_FILIAL FROM V_PRC_FILIAL_NAO_INDICADORES WHERE CD_EMP=@CD_EMP)
	GROUP BY   
		a.CD_FILIAL,
		a.CD_PROD,	 
		a.DT_VD) VD_PROD 
INNER JOIN 
	(SELECT   		
		a.DT_VD,   
		SUM(a.VLR_MEDIO_VD) AS VLR_MEDIO_VD,   
		SUM(a.QT_VD_DIA) As QT_VD_DIA,   
		SUM(a.PART_QTDE) AS PART_QTDE_VD,   
		SUM(a.PART_VLR) As PART_VLR_VD 
	FROM 
		EST_PROD_CPL_ANALISE_DIARIO a 
		INNER JOIN EST_PROD p ON 
		a.CD_EMP = p.CD_EMP AND 
		a.Cd_Prod = P.Cd_Prod 
	WHERE   
		a.CD_EMP =@CD_EMP
		AND a.DT_VD = @DT_INI
		AND p.STS_PROD = 0
		AND p.FLAG_ANALISE_FALTAS=0
		AND a.CD_FILIAL NOT IN (SELECT CD_FILIAL FROM V_PRC_FILIAL_NAO_INDICADORES WHERE CD_EMP=@CD_EMP)
	GROUP BY   
		a.DT_VD) VD ON 		
	VD_PROD.DT_VD = VD.DT_VD 
INNER JOIN
	(SELECT	
		C.CD_FILIAL,
		P.CD_PROD, 
		P.DS_PROD, 
		CASE WHEN P.COMPRA_POR_SUPRIMENTO = 1 THEN 
		'SUPRIMENTO' ELSE 'RESSUPRIMENTO' END AS TIPO, 
		F.NM_FABRIC, 
		LINHA.DS_ARV_MERC_LINHA, 
		SIGLA.DS_SIGLA,
		C2.MEDIAF,
		C2.QT_EST + C2.QT_EST_EM_TERC EST_MTZ,
		S2.QT_PEND_ENT QT_PEND_MTZ,
		S.QT_PEND_ENT QT_PEND_LJ,
		ROUND((C.MEDIAF/ 30.0) * C.EMAX ,0) EMAX,
		CASE WHEN C.QTDE_LIMITADOR > 0  THEN
			CASE WHEN C.QTDE_LIMITADOR < C.QTDE_FACEAMENTO OR
				C.QTDE_LIMITADOR < C.QTDE_FINANCIADO OR
							(ROUND((C.MEDIAF/ 30.0) * C.EMAX ,0)) < C.QTDE_LIMITADOR THEN
					C.QTDE_LIMITADOR - (C.QT_EST + C.QT_EST_EM_TERC)
			WHEN (ROUND((C.MEDIAF/ 30.0) * C.EMAX ,0)) > C.QTDE_FACEAMENTO AND (ROUND((C.MEDIAF/ 30.0) * C.EMAX ,0)) > C.QTDE_FACEAMENTO THEN
				(ROUND((C.MEDIAF/ 30.0) * C.EMAX ,0))
			WHEN C.QTDE_FACEAMENTO > (ROUND((C.MEDIAF/ 30.0) * C.EMAX ,0)) AND C.QTDE_FACEAMENTO > C.QTDE_FINANCIADO THEN
				C.QTDE_FACEAMENTO - (C.QT_EST + C.QT_EST_EM_TERC)
			WHEN C.QTDE_FINANCIADO > (ROUND((C.MEDIAF/ 30.0) * C.EMAX ,0)) AND C.QTDE_FINANCIADO > C.QTDE_FACEAMENTO THEN
				C.QTDE_FINANCIADO - (C.QT_EST + C.QT_EST_EM_TERC)
			END
		ELSE
			CASE WHEN (ROUND((C.MEDIAF/ 30.0) * C.EMAX ,0)) > C.QTDE_FACEAMENTO AND (ROUND((C.MEDIAF/ 30.0) * C.EMAX ,0)) > C.QTDE_FACEAMENTO THEN
				(ROUND((C.MEDIAF/ 30.0) * C.EMAX ,0)) - (C.QT_EST + C.QT_EST_EM_TERC)
			WHEN C.QTDE_FACEAMENTO > (ROUND((C.MEDIAF/ 30.0) * C.EMAX ,0)) AND C.QTDE_FACEAMENTO > C.QTDE_FINANCIADO THEN
				C.QTDE_FACEAMENTO - (C.QT_EST + C.QT_EST_EM_TERC)
			WHEN C.QTDE_FINANCIADO > (ROUND((C.MEDIAF/ 30.0) * C.EMAX ,0)) AND C.QTDE_FINANCIADO > C.QTDE_FACEAMENTO THEN
				C.QTDE_FINANCIADO - (C.QT_EST + C.QT_EST_EM_TERC)
			ELSE
				0
			END
		END AS NECESSIDADE

	FROM              
		EST_PROD P 
		
		INNER JOIN 
		EST_PROD_FABRIC F  ON 
		P.CD_FABRIC = F.CD_FABRIC 
		
		INNER JOIN EST_PROD_CPL C ON 
		P.CD_EMP = C.CD_EMP AND 
		P.CD_PROD = C.CD_PROD    
		
		INNER JOIN EST_PROD_CPL C2 ON 
		P.CD_EMP = C2.CD_EMP AND 
		P.CD_PROD = C2.CD_PROD    
		
		INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON 
		P.CD_EMP = A.CD_EMP AND 
		P.CD_PROD = A.CD_PROD    
		
		INNER JOIN EST_ARV_MERC_LINHA LINHA ON 
		A.CD_EMP = LINHA.CD_EMP AND 
		A.CD_ARV_MERC_LINHA = LINHA.CD_ARV_MERC_LINHA
		
		INNER JOIN V_EST_PROD_CPL_PENDENCIAS_SUPRIMENTO S ON 
		C.CD_EMP = S.CD_EMP AND 
		C.CD_FILIAL = S.CD_FILIAL AND 
		C.CD_PROD = S.CD_PROD

		INNER JOIN V_EST_PROD_CPL_PENDENCIAS_SUPRIMENTO S2 ON 
		C2.CD_EMP = S2.CD_EMP AND 
		C2.CD_FILIAL = S2.CD_FILIAL AND 
		C2.CD_PROD = S2.CD_PROD

		INNER JOIN  EST_PROD_CURVA_SIGLA SIGLA ON 
		C2.CD_EMP = SIGLA.CD_EMP AND
		C2.CD_SIGLA = SIGLA.CD_SIGLA
	WHERE
		P.CD_EMP = @CD_EMP
		AND C.CD_FILIAL NOT IN (SELECT CD_FILIAL FROM V_PRC_FILIAL_NAO_INDICADORES WHERE CD_EMP=@CD_EMP)
		AND C2.CD_FILIAL = (SELECT CD_FILIAL FROM V_PRC_FILIAL_RELACAO_DEPOSITOS WHERE DEPOSITO_AUXILIAR='NAO')
		AND P.FLAG_ANALISE_FALTAS = 0
		AND p.STS_PROD = 0
	) CPL ON	
	VD_PROD.CD_PROD = CPL.CD_PROD AND
	VD_PROD.CD_FILIAL = CPL.CD_FILIAL
INNER JOIN (SELECT 
		CD_PROD,
		SUM(QT_EXCESSO) EXCESSO
	FROM 
		EST_PROD_CPL_ANALISE_DIARIO
	WHERE
		DT_VD = @DT_INI
		AND CD_EMP = @CD_EMP
		AND CD_FILIAL NOT IN (SELECT CD_FILIAL FROM V_PRC_FILIAL_NAO_INDICADORES WHERE CD_EMP=@CD_EMP)		
	GROUP BY
		CD_PROD) E ON

VD_PROD.CD_PROD = E.CD_PROD 

Where 
	VD_PROD.PART_QTDE > 0 
	AND VD_PROD.DT_VD = @DT_INI
	AND	NOT EXISTS (SELECT * 
					FROM 
						EST_PROD_CPL_ANALISE_FALTAS_FILIAL
					WHERE  
						DT_MOV = VD_PROD.DT_VD 
						AND CD_EMP = @CD_EMP 
						AND CD_PROD = VD_PROD.CD_PROD
						AND CD_FILIAL = VD_PROD.CD_FILIAL);

GO


